// Z80 (Zed Eight-Ty) Interface

#ifndef FASTCALL
 #undef __fastcall
 #define __fastcall
#endif

#include "z80.h"

extern INT32 nHasZet2;
void Zet2WriteByte(UINT16 address, UINT8 data);
UINT8 Zet2ReadByte(UINT16 address);
void Zet2WriteRom(UINT16 address, UINT8 data);
INT32 Zet2Init(INT32 nCount);
void Zet2Exit();
void Zet2NewFrame();
void Zet2Open(INT32 nCPU);
void Zet2Close();
INT32 Zet2GetActive();

#define ZET2_FETCHOP	4
#define ZET2_FETCHARG	8
#define ZET2_READ	1
#define ZET2_WRITE	2
#define ZET2_FETCH	(ZET2_FETCHOP|ZET2_FETCHARG)
#define ZET2_ROM		(ZET2_READ|ZET2_FETCH)
#define ZET2_RAM		(ZET2_ROM|ZET2_WRITE)

INT32 Zet2UnmapMemory(INT32 nStart,INT32 nEnd,INT32 nFlags);
void Zet2MapMemory(UINT8 *Mem, INT32 nStart, INT32 nEnd, INT32 nFlags);

INT32 Zet2MemCallback(INT32 nStart,INT32 nEnd,INT32 nMode);
INT32 Zet2MapArea(INT32 nStart, INT32 nEnd, INT32 nMode, UINT8 *Mem);
INT32 Zet2MapArea(INT32 nStart, INT32 nEnd, INT32 nMode, UINT8 *Mem01, UINT8 *Mem02);

void Zet2Reset();
UINT32 Zet2GetPC(INT32 n);
INT32 Zet2GetPrevPC(INT32 n);
INT32 Zet2Bc(INT32 n);
INT32 Zet2De(INT32 n);
INT32 Zet2HL(INT32 n);
INT32 Zet2I(INT32 n);//
INT32 Zet2Scan(INT32 nAction);
INT32 Zet2Run(INT32 nCycles);
void Zet2RunEnd();
void Zet2SetIRQLine(const INT32 line, const INT32 status);
void Zet2SetVector(INT32 vector);
UINT8 Zet2GetVector();
INT32 Zet2Nmi();
INT32 Zet2Idle(INT32 nCycles);
INT32 Zet2SegmentCycles();
INT32 Zet2TotalCycles();
void Zet2SetHL(INT32 n, UINT16 value);
void Zet2SetSP(INT32 n, UINT16 value);

#define ZET2_IRQSTATUS_NONE 0
#define ZET2_IRQSTATUS_ACK  1
#define ZET2_IRQSTATUS_AUTO 2
#define ZET2_IRQSTATUS_HOLD 4
#define ZET2_IRQSTATUS_HOLD2 5

#define Zet2RaiseIrq(n) Zet2SetIRQLine(n, ZET2_IRQSTATUS_AUTO)
#define Zet2LowerIrq() Zet2SetIRQLine(0, Z80_CLEAR_LINE)

void Zet2SetReadHandler(UINT8 (__fastcall *pHandler)(UINT16));
void Zet2SetWriteHandler(void (__fastcall *pHandler)(UINT16, UINT8));
void Zet2SetInHandler(UINT8 (__fastcall *pHandler)(UINT16));
void Zet2SetOutHandler(void (__fastcall *pHandler)(UINT16, UINT8));

void Zet2SetBUSREQLine(INT32 nStatus);
